/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: EplCnDpm_Functionlist.h $

    $GlobalRev: unknown $
    $Version: V2.1.53.0 $
    $Packaged: 2015-10-26 16:18 $

   Targets:

   Description:



  Functions:


   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           11.10.2007  SB        created
*******************************************************************************/

#ifndef EPLCNDPM_FUNCTIONLIST_H_INCLUDED
#define EPLCNDPM_FUNCTIONLIST_H_INCLUDED

/***************************************************************************************/
/* Epl Nmt function list, prototyes */

TLR_RESULT  TaskExit_EplCnDpm ( void* pvRsc);

TLR_RESULT  TaskLeave_EplCnDpm( void* pvRsc,
                                void* pvLve);

void TaskEnter_EplCnDpm( void* pvInit);

typedef struct
{
  RX_PHYSICALDRIVE_HEADER_T  tIdentParam;
  TLR_UINT32                 ulBytePerFlashSector;
  TLR_UINT32                 ulFATStartOffset;
} EPLCN_DPM_FLASH_PARAM_T;

typedef struct
{
  char*                      pzFileName;
} EPLCN_DPM_FAT_PARAM_T;

/*=============================================================================*/
typedef struct EPLCN_ADDRESS_SWITCH_INIT_HEADER_Ttag* EPLCN_ADDRESS_SWITCH_HANDLE;

typedef struct EPLCN_ADDRESS_SWITCH_INIT_HEADER_Ttag
{
  TLR_RESULT (* pfnAddressSwitchInit)(
      const struct EPLCN_ADDRESS_SWITCH_INIT_HEADER_Ttag* ptAddrSwitchInitData,
      EPLCN_ADDRESS_SWITCH_HANDLE* phAddrSwitchHandle);
  /* next two are initialized within pptAddrSwitchHandle only { */
  void (* pfnAddressSwitchDeinit)(
      EPLCN_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle);
  uint32_t (* pfnAddressSwitchGet)(
      EPLCN_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle);
  /* } */
} EPLCN_ADDRESS_SWITCH_INIT_HEADER_T;

/*=============================================================================*/

typedef struct EPLCN_DPM_PARAMETER_Ttag
{
  TLR_TASK_PARAMETERHEADER;
  struct
  {
    TLR_BOOLEAN              fActivateSWNodeId;
    EPLCN_DPM_FLASH_PARAM_T* ptFlashPrm;
    EPLCN_DPM_FAT_PARAM_T*   ptFATPrm;
  } tSWNodeIdConfig;

  const EPLCN_ADDRESS_SWITCH_INIT_HEADER_T* ptAddressSwitchInit;
} EPLCN_DPM_PARAMETER_T;

#define EPLCN_DPM_STARTUP_PARAM_VERSION (1)

/*=============================================================================*/

#ifdef __ROTARYSWITCH_INCLUDES_H
#include <malloc.h>

typedef struct EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_Ttag
{
  EPLCN_ADDRESS_SWITCH_INIT_HEADER_T tHead;

  ROTARYSWITCH_INIT_FKT_T pfnInitAddressSwitch;
  ROTARYSWITCH_CONFIG_PARAMETER_T* ptAddressSwitchParam;
  /* internal will be used internally { */
  ROTARYSWITCH_GET_FKT_T pfnGetAddressSwitch;
  ROTARYSWITCH_DEINIT_FKT_T pfnDeinitAddressSwitch;
  void* pvFuncParam;
  /* } */
} EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T;

static
void
Pls_Deinit_AddressSwitch_From_RotarySwitch(
    EPLCN_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle)
{
  EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle = (EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*) hAddrSwitchHandle;
  ptRotarySwitchHandle->pfnDeinitAddressSwitch(ptRotarySwitchHandle->pvFuncParam);
  free(ptRotarySwitchHandle);
}

static
uint32_t
Pls_Get_AddressSwitch_From_RotarySwitch(
    EPLCN_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle)
{
  EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle = (EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*) hAddrSwitchHandle;
  return ptRotarySwitchHandle->pfnGetAddressSwitch(ptRotarySwitchHandle->pvFuncParam);
}

static
TLR_RESULT
Pls_Init_AddressSwitch_From_RotarySwitch(
    const EPLCN_ADDRESS_SWITCH_INIT_HEADER_T* ptAddressSwitchInit,
    EPLCN_ADDRESS_SWITCH_HANDLE* phAddrSwitchHandle)
{
  TLR_RESULT tResult;
  EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchParams = (EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*)ptAddressSwitchInit;
  EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle;

  ptRotarySwitchHandle = malloc(sizeof(*ptRotarySwitchHandle));
  if(NULL == ptRotarySwitchHandle)
  {
    tResult = TLR_E_OUTOFMEMORY;
  }
  else
  {
    *ptRotarySwitchHandle = *ptRotarySwitchParams;
    ptRotarySwitchHandle->tHead.pfnAddressSwitchDeinit = Pls_Deinit_AddressSwitch_From_RotarySwitch;
    ptRotarySwitchHandle->tHead.pfnAddressSwitchGet = Pls_Get_AddressSwitch_From_RotarySwitch;
    tResult = ptRotarySwitchHandle->pfnInitAddressSwitch(
        &ptRotarySwitchHandle->pfnGetAddressSwitch,
        &ptRotarySwitchHandle->pfnDeinitAddressSwitch,
        ptRotarySwitchHandle->ptAddressSwitchParam,
        &ptRotarySwitchHandle->pvFuncParam);
    if(TLR_S_OK != tResult)
    {
      free(ptRotarySwitchHandle);
      ptRotarySwitchHandle = NULL;
    }
  }
  *phAddrSwitchHandle = &ptRotarySwitchHandle->tHead;
  return tResult;
}

#define DEFINE_EPLCN_ROTARY_SWITCH_AS_ADDRESS_SWITCH(tName, pfnInitAddressSwitch, ptAddressSwitchParam) \
    const EPLCN_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T tName = \
    { \
      { \
        Pls_Init_AddressSwitch_From_RotarySwitch \
      }, \
      pfnInitAddressSwitch, \
      ptAddressSwitchParam \
    }

#define USE_EPLCN_ROTARY_SWITCH_AS_ADDRESS_SWITCH(tName) \
    (tName.tHead)

#endif

/*=============================================================================*/

#endif // EPLCNDPM_FUNCTIONLIST_H_INCLUDED
